#{{uc_id}}{
 width:100%;
}

.container_{{uc_id}}{
  display: flex;
  justify-content: {{align_bg}};
}

#{{uc_id}} a{
  display:inline-block;
  transition:0.5s;
  text-decoration:none;
}

.ue_play_button{
  text-align:{{align}};
}

#{{uc_id}} a:hover{
  transform:scale(1.1,1.1);
}

#{{uc_id}} a span.video-button{
  display:inline-block;
  align-items: center;
  justify-content: center;
  flex-direction: column; 
  display:flex;
  position:relative;
  transition:0.3s;
  line-height:1em;
}

.ue-play-bg{
  background-size:cover;
  background-position:center;
  background-repeat:none;
  max-width:100%; 
}

#{{uc_id}} a span.video-button svg{
  height:1em;
  width:1em;
}

#{{uc_id}} i{
  vertical-align:middle;
  transition:0.3s;
}

{% if enable_ripple == "true" %}
#{{uc_id}} a span:before{
  content: '';
    display: inline-block;
    position: absolute;
    top: -2px;
    left: -2px;
    bottom: -2px;
    right: -2px;
    border-radius: inherit;
    border: 1px solid {{ripple_color}};
    -webkit-animation: btnIconRipple 2s cubic-bezier(0.23, 1, 0.32, 1) both infinite;
    animation: btnIconRipple 2s cubic-bezier(0.23, 1, 0.32, 1) both infinite;
    border-color: {{ripple_color}};
}

@keyframes btnIconRipple {
  0% {
    border-width: 4px;
            transform: scale(1);
  }
  80% {
    border-width: 1px;
            transform: scale(1.35);
  }
  100% {
    opacity: 0;
  }
}
{% endif %}


{% if add_background == "true" %}
.ue-play-bg{
  display:flex;
  align-items:center;
  justify-content:center;
}
{% endif %}

{% if enable_attention_grabber == 'true' %}

	{% if attention_grabber == 'ue-video-popup-waggle' %}
	  .button_{{uc_id}}{
          animation: ue-video-popup-waggle 5s infinite;
      }

      @keyframes ue-video-popup-waggle {
          0% {
              transform: none;
          }

          10% {
              transform: rotateZ(-20deg) scale(1.2);
          }

          13% {
              transform: rotateZ(25deg) scale(1.2);
          }

          15% {
              transform: rotateZ(-15deg) scale(1.2);
          }

          17% {
              transform: rotateZ(15deg) scale(1.2);
          }

          20% {
              transform: rotateZ(-12deg) scale(1.2);
          }

          22% {
              transform: rotateZ(0) scale(1.2);
          }

          25%,
          100% {
              transform: rotateZ(0) scale(1);
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-video-popup-fade' %}
        .button_{{uc_id}} {
          animation: ue-video-popup-fade 5s infinite;
      }

      @keyframes ue-video-popup-fade {
          5% {
              opacity: .25;
          }

          10% {
              opacity: 1;
          }

          15% {
              opacity: .25;
          }

          20%,
          100% {
              opacity: 1;
          }
      }
	{% endif %}
	
	{% if attention_grabber == 'ue-video-popup-blink' %}
        .button_{{uc_id}} {
          animation: ue-video-popup-blink 1.33s ease-out infinite;
      }

      @keyframes ue-video-popup-blink {
          0% {
              opacity: 1;
          }

          20% {
              opacity: .5;
          }

          100% {
              opacity: 1;
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-video-popup-grow' %}
    .button_{{uc_id}} {
          animation: ue-video-popup-grow .4s ease infinite alternate;
      }

      @keyframes ue-video-popup-grow {
          0% {
              transform: scale(1);
              border-radius: 50%;
          }

          100% {
              transform: scale(1.1);
              border-radius: 50%;
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-video-popup-bounce' %}
    .button_{{uc_id}}{
          animation: ue-video-popup-bounce 5s infinite cubic-bezier(.84, -.54, .31, 1.19);
      }

      @keyframes ue-video-popup-bounce {
          0% {
              transform: none;
          }

          10% {
              transform: translateY(-1em);
          }

          100%,
          20% {
              transform: none;
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-video-popup-spin' %}
    .button_{{uc_id}} {
          animation: ue-video-popup-spin 5s infinite cubic-bezier(.56, -.35, .22, 1.5);
      }

      @keyframes ue-video-popup-spin {
          10% {
              transform: rotateZ(-20deg);
              animation-timing-function: ease;
          }

          100%,
          20% {
              transform: rotateZ(360deg);
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-video-popup-shine' %}
	  
    .button_{{uc_id}} {
          position: relative;
          overflow: hidden;
          border-radius:80px;
      }
      .button_{{uc_id}}:after {
          animation: ue-video-popup-shine 5s infinite;
          content: '';
          position: absolute;
          top: 0;
          right: 0;
          bottom: 0;
          left: 0;
          background: linear-gradient(to bottom, transparent, {{shine_color}} 50%, transparent);
          transform: rotateZ(60deg) translate(0, 5em);
      }

      @keyframes ue-video-popup-shine {
          20%,
          100% {
              transform: rotateZ(60deg) translate(0, -80px);
          }
      }
    {% endif %}
{% endif %}

{% if custom_close_icon == "true" %}
.lity-close i{
  color:{{close_icon_color}}!important;
  cursor:pointer;
  pointer-events: none;
}
.lity-close:hover i{
  color:{{close_icon_color_hover}}!important;
}

.lity-close svg{
  fill:{{close_icon_color}}!important;
  width:1em;
  height:1em;
  cursor:pointer;
  pointer-events: none;
}

.lity-close:hover svg{
  fill:{{close_icon_color_hover}}!important;
}
{% endif %}

.lity-close{
  display: flex;
  align-items: center;
  justify-content: center;
  padding:0!important;
  color:{{close_icon_color}};
  font-size: {{close_icon_size}}!important;
  background-color:{{close_icon_background_color}};
  {% if close_icon_border_radius is not empty %}border-radius:{{close_icon_border_radius}};{% endif %}
  {% if icon_gap_top is not empty %}top:{{icon_gap_top}};{% endif %}
  {% if icon_gap_right is not empty %}right:{{icon_gap_right}};{% endif %}
}

.lity-close *{
  transition: all 200ms;
}

.lity-close:hover{
  background-color:{{close_icon_background_color_hover}};
  color:{{close_icon_color_hover}};
}

.lity-iframe .lity-container, 
.lity-youtube .lity-container, 
.lity-vimeo .lity-container, 
.lity-facebookvideo .lity-container, 
.lity-googlemaps .lity-container{
  max-width: {{video_max_width}};
}

@media (max-width: 767px) {
 .lity-close{
    font-size: {{close_icon_size_mobile}}!important;
  }
}
@media (max-width: 1024px) {
 .lity-close{
    font-size: {{close_icon_size_tablet}}!important;
  }
}