{# twig vars #}{##}
{% set itemClass = "ue-social-buttons-share-list-item" %}
{% set buttonAttr %}role="button" tabindex="0"{% endset %}
{% set fbTitleElem %}{% if show_title == "true" %}<span class="{{itemClass}}-text">{% if item.title is empty %}Facebook{% else %}{{item.title}}{% endif %}</span>{% endif %}{% endset %}
{% set xTitleElem %}{% if show_title == "true" %}<span class="{{itemClass}}-text">{% if item.title is empty %}X{% else %}{{item.title}}{% endif %}</span>{% endif %}{% endset %}
{% set whatTitleElem %}{% if show_title == "true" %}<span class="{{itemClass}}-text">{% if item.title is empty %}WhatsApp{% else %}{{item.title}}{% endif %}</span>{% endif %}{% endset %}
{% set copyTitleElem %}{% if show_title == "true" %}<span class="{{itemClass}}-text">{% if item.title is empty %}Copy Link{% else %}{{item.title}}{% endif %}</span>{% endif %}{% endset %}
{% set printTitleElem %}{% if show_title == "true" %}<span class="{{itemClass}}-text">{% if item.title is empty %}Print{% else %}{{item.title}}{% endif %}</span>{% endif %}{% endset %}
{% set mailTitleElem %}{% if show_title == "true" %}<span class="{{itemClass}}-text">{% if item.title is empty %}Email{% else %}{{item.title}}{% endif %}</span>{% endif %}{% endset %}
{% set linkedinTitleElem %}{% if show_title == "true" %}<span class="{{itemClass}}-text">{% if item.title is empty %}LinkedIn{% else %}{{item.title}}{% endif %}</span>{% endif %}{% endset %}
{% set pinterestTitleElem %}{% if show_title == "true" %}<span class="{{itemClass}}-text">{% if item.title is empty %}Pinterest{% else %}{{item.title}}{% endif %}</span>{% endif %}{% endset %}
{% set telegramTitleElem %}{% if show_title == "true" %}<span class="{{itemClass}}-text">{% if item.title is empty %}Telegram{% else %}{{item.title}}{% endif %}</span>{% endif %}{% endset %}

{% set fbIconElem %}{% if show_icon == "true" %}<span class="{{itemClass}}-icon">{% if item.icon is empty %}<i class="fab fa-facebook-f"></i>{% else %}{{item.icon_html|raw}}{% endif %}</span>{% endif %}{% endset %}
{% set xIconElem %}{% if show_icon == "true" %}<span class="{{itemClass}}-icon">{% if item.icon is empty %}<i class="fab fa-x-twitter"></i>{% else %}{{item.icon_html|raw}}{% endif %}</span>{% endif %}{% endset %}
{% set whatIconElem %}{% if show_icon == "true" %}<span class="{{itemClass}}-icon">{% if item.icon is empty %}<i class="fab fa-whatsapp"></i>{% else %}{{item.icon_html|raw}}{% endif %}</span>{% endif %}{% endset %}
{% set copyIconElem %}{% if show_icon == "true" %}<span class="{{itemClass}}-icon">{% if item.icon is empty %}<i class="far fa-copy"></i>{% else %}{{item.icon_html|raw}}{% endif %}</span>{% endif %}{% endset %}
{% set printIconElem %}{% if show_icon == "true" %}<span class="{{itemClass}}-icon">{% if item.icon is empty %}<i class="fas fa-print"></i>{% else %}{{item.icon_html|raw}}{% endif %}</span>{% endif %}{% endset %}
{% set mailIconElem %}{% if show_icon == "true" %}<span class="{{itemClass}}-icon">{% if item.icon is empty %}<i class="far fa-envelope"></i>{% else %}{{item.icon_html|raw}}{% endif %}</span>{% endif %}{% endset %}
{% set linkedinIconElem %}{% if show_icon == "true" %}<span class="{{itemClass}}-icon">{% if item.icon is empty %}<i class="fab fa-linkedin-in"></i>{% else %}{{item.icon_html|raw}}{% endif %}</span>{% endif %}{% endset %}
{% set pinterestIconElem %}{% if show_icon == "true" %}<span class="{{itemClass}}-icon">{% if item.icon is empty %}<i class="fab fa-pinterest-p"></i>{% else %}{{item.icon_html|raw}}{% endif %}</span>{% endif %}{% endset %}
{% set telegramIconElem %}{% if show_icon == "true" %}<span class="{{itemClass}}-icon">{% if item.icon is empty %}<i class="fab fa-telegram-plane"></i>{% else %}{{item.icon_html|raw}}{% endif %}</span>{% endif %}{% endset %}

{# end twig vars #}{##}

<div id="{{item.item_id}}" class="ue-social-buttons-item {{item.item_repeater_class}}">
  
  {% if item.network == "fb" %}
    <div class="{{itemClass}}" data-link-type="facebook" aria-label="Share on Facebook" {{buttonAttr}}>
      {{fbIconElem}}
      {{fbTitleElem}}
    </div>
  {% elseif item.network == "x" %}
    <div class="{{itemClass}}" data-link-type="twitter" aria-label="Share on X" {{buttonAttr}}>
      {{xIconElem}}
      {{xTitleElem}}
    </div>
  {% elseif item.network == "what" %}
    <div class="{{itemClass}}" data-link-type="whatsapp" aria-label="Share on WhatsApp" {{buttonAttr}}>
      {{whatIconElem}}
      {{whatTitleElem}}
    </div>
  {% elseif item.network == "copy" %}
    <div class="{{itemClass}}" data-link-type="link" aria-label="Copy Link" data-copied-text="{{item.copied_text|e('html_attr')}}" {{buttonAttr}}>
      {{copyIconElem}}
      {{copyTitleElem}}
    </div>
  {% elseif item.network == "print" %}
    <div class="{{itemClass}}" data-link-type="print" aria-label="Print Page" {{buttonAttr}}>
      {{printIconElem}}
      {{printTitleElem}}
    </div>
  {% elseif item.network == "mail" %}
    <div class="{{itemClass}} {{itemClass}}-link" data-link-type="email" aria-label="Share on Email" {{buttonAttr}}>
      {{mailIconElem}}
      {{mailTitleElem}}
    </div>
  {% elseif item.network == "linkedin" %}
    <div class="{{itemClass}} {{itemClass}}-link" data-link-type="linkedin" aria-label="Share on LinkedIn" {{buttonAttr}}>
      {{linkedinIconElem}}
      {{linkedinTitleElem}}
    </div>
  {% elseif item.network == "pinterest" %}
    <div class="{{itemClass}} {{itemClass}}-link" data-link-type="pinterest" aria-label="Share on Pinterest" {{buttonAttr}}>
      {{pinterestIconElem}}
      {{pinterestTitleElem}}
    </div>
  {% elseif item.network == "telegram" %}
    <div class="{{itemClass}} {{itemClass}}-link" data-link-type="telegram" aria-label="Share on Telegram" {{buttonAttr}}>
      {{telegramIconElem}}
      {{telegramTitleElem}}
    </div>
  {% endif %}

</div>{# end ue-social-buttons-item #}{##}